-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost:8889
-- Generation Time: Nov 04, 2025 at 08:09 AM
-- Server version: 8.0.40
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `hybrid_users`
--

-- --------------------------------------------------------

--
-- Table structure for table `approval_actions`
--

CREATE TABLE `approval_actions` (
  `id` int NOT NULL,
  `request_id` int NOT NULL,
  `step_id` int NOT NULL,
  `actor_id` varchar(100) NOT NULL,
  `actor_name` varchar(255) DEFAULT NULL,
  `action` enum('approve','reject','delegate','escalate') NOT NULL,
  `comment` text,
  `metadata` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `approval_levels`
--

CREATE TABLE `approval_levels` (
  `id` int NOT NULL,
  `workflow_id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `order` int NOT NULL,
  `required` tinyint(1) DEFAULT '1',
  `roles` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `approval_levels`
--

INSERT INTO `approval_levels` (`id`, `workflow_id`, `name`, `order`, `required`, `roles`, `created_at`, `updated_at`) VALUES
(1, 1, 'Supervisor Review', 1, 1, '[\"supervisor\", \"coordinator\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(2, 1, 'Manager Approval', 2, 1, '[\"manager\", \"director\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(3, 1, 'Finance Review', 3, 1, '[\"finance_manager\", \"accountant\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(4, 2, 'Coordinator Review', 1, 1, '[\"coordinator\", \"supervisor\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(5, 3, 'Quality Manager Review', 1, 1, '[\"quality_manager\", \"supervisor\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(6, 3, 'Production Manager Approval', 2, 1, '[\"production_manager\", \"manager\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(7, 4, 'Accountant Review', 1, 1, '[\"accountant\", \"finance_officer\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(8, 4, 'Finance Manager Approval', 2, 1, '[\"finance_manager\", \"director\"]', '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(9, 5, 'Manager Review', 1, 1, '[\"SUPPLY_CHAIN_MANAGER\", \"HEAD_OF_SUPPLY_CHAIN\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(10, 5, 'Finance Approval', 2, 1, '[\"FINANCE_MANAGER\", \"CFO\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(11, 6, 'Manager Review', 1, 1, '[\"SUPPLY_CHAIN_MANAGER\", \"HEAD_OF_SUPPLY_CHAIN\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(12, 7, 'Manager Approval', 1, 1, '[\"SUPPLY_CHAIN_MANAGER\", \"HEAD_OF_SUPPLY_CHAIN\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(13, 7, 'Finance Approval', 2, 1, '[\"FINANCE_MANAGER\", \"CFO\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(14, 8, 'Procurement Review', 1, 1, '[\"PROCUREMENT_MANAGER\", \"SUPPLY_CHAIN_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(15, 8, 'Legal Review', 2, 1, '[\"LEGAL_MANAGER\", \"COMPLIANCE_OFFICER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(16, 9, 'Procurement Review', 1, 1, '[\"PROCUREMENT_MANAGER\", \"SUPPLY_CHAIN_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(17, 10, 'Manager Approval', 1, 1, '[\"SUPPLY_CHAIN_MANAGER\", \"HEAD_OF_SUPPLY_CHAIN\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(18, 10, 'Finance Review', 2, 1, '[\"FINANCE_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(19, 11, 'Inventory Manager', 1, 1, '[\"INVENTORY_MANAGER\", \"SUPPLY_CHAIN_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(20, 12, 'Fleet Manager', 1, 1, '[\"FLEET_MANAGER\", \"LOGISTICS_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(21, 13, 'Weighbridge Supervisor', 1, 1, '[\"WEIGHBRIDGE_SUPERVISOR\", \"QUALITY_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(22, 14, 'Quality Manager', 1, 1, '[\"QUALITY_MANAGER\", \"HEAD_OF_QUALITY\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(23, 15, 'Accounts Manager', 1, 1, '[\"ACCOUNTS_MANAGER\", \"FINANCE_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(24, 15, 'Finance Director', 2, 1, '[\"FINANCE_DIRECTOR\", \"CFO\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(25, 16, 'Cost Controller', 1, 1, '[\"COST_CONTROLLER\", \"FINANCE_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(26, 17, 'Process Manager', 1, 1, '[\"PROCESS_MANAGER\", \"SUPPLY_CHAIN_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(27, 18, 'Operations Manager', 1, 1, '[\"OPERATIONS_MANAGER\", \"SUPPLY_CHAIN_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(28, 18, 'Finance Review', 2, 1, '[\"FINANCE_MANAGER\", \"ACCOUNTS_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(29, 19, 'Data Security Officer', 1, 1, '[\"DATA_SECURITY_OFFICER\", \"IT_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(30, 20, 'Security Manager', 1, 1, '[\"SECURITY_MANAGER\", \"FACILITY_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33'),
(31, 21, 'Fleet Manager', 1, 1, '[\"FLEET_MANAGER\", \"LOGISTICS_MANAGER\"]', '2025-08-21 08:18:33', '2025-08-21 08:18:33');

-- --------------------------------------------------------

--
-- Table structure for table `approval_requests`
--

CREATE TABLE `approval_requests` (
  `id` int NOT NULL,
  `workflow_id` int NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `module` varchar(100) NOT NULL,
  `operation` varchar(100) NOT NULL,
  `entity_type` varchar(100) DEFAULT NULL,
  `entity_id` int DEFAULT NULL,
  `requester_id` varchar(100) DEFAULT NULL,
  `requester_name` varchar(255) DEFAULT NULL,
  `requester_email` varchar(255) DEFAULT NULL,
  `requester_department` varchar(255) DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `status` enum('pending','under_review','approved','rejected','cancelled') DEFAULT 'pending',
  `current_level` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `payload` json DEFAULT NULL COMMENT 'The full operation payload',
  `resource_ref` varchar(255) DEFAULT NULL COMMENT 'Client-visible correlation key',
  `correlation_id` varchar(255) DEFAULT NULL COMMENT 'For tracing across services',
  `current_step_order` int DEFAULT '1' COMMENT 'Current approval step order'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `approval_requests`
--

INSERT INTO `approval_requests` (`id`, `workflow_id`, `title`, `description`, `module`, `operation`, `entity_type`, `entity_id`, `requester_id`, `requester_name`, `requester_email`, `requester_department`, `priority`, `status`, `current_level`, `created_at`, `updated_at`, `payload`, `resource_ref`, `correlation_id`, `current_step_order`) VALUES
(1, 1, 'Purchase Order #PO-2024-001', 'New purchase order for raw materials worth ₦2,500,000', 'supply_chain', 'create', 'purchase_order', 1, '1', 'John Doe', 'john.doe@company.com', 'Procurement', 'high', 'pending', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56', NULL, NULL, NULL, 1),
(2, 2, 'Supplier Update - ABC Corp', 'Update supplier contact information and payment terms', 'supply_chain', 'update', 'supplier', 1, '1', 'Sarah Wilson', 'sarah.wilson@company.com', 'Supply Chain', 'medium', 'pending', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56', NULL, NULL, NULL, 1),
(3, 3, 'Quality Control Report', 'Critical quality control report requires immediate approval', 'quality_control', 'create', 'quality_report', 1, '1', 'Mike Johnson', 'mike.johnson@company.com', 'Quality Control', 'urgent', 'pending', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56', NULL, NULL, NULL, 1),
(4, 1, 'SUPPLY CHAIN - CREATE PURCHASE_ORDER', NULL, 'supply_chain', 'create_purchase_order', NULL, NULL, 'test-user', 'Test User', NULL, NULL, 'medium', 'pending', 1, '2025-10-25 16:31:38', '2025-10-25 16:31:38', '{\"items\": [{\"quantity\": 100, \"unit_price\": 5000, \"description\": \"Test Material\", \"raw_material_id\": 1, \"unit_of_measure\": \"KG\"}], \"notes\": \"Test PO for approval workflow\", \"branch_id\": 1, \"created_by\": \"test-user\", \"supplier_id\": 1, \"expected_delivery_date\": \"2025-12-01\"}', 'PO-TEST-123', 'corr-12345', 1),
(5, 1, 'SUPPLY CHAIN - CREATE PURCHASE_ORDER', NULL, 'supply_chain', 'create_purchase_order', NULL, NULL, 'test-user', 'Test User', NULL, NULL, 'medium', 'pending', 1, '2025-10-25 16:32:38', '2025-10-25 16:32:38', '{\"items\": [{\"quantity\": 100, \"unit_price\": 5000, \"description\": \"Test Material\", \"raw_material_id\": 1, \"unit_of_measure\": \"KG\"}], \"notes\": \"Test PO for approval workflow\", \"branch_id\": 1, \"created_by\": \"test-user\", \"supplier_id\": 1, \"expected_delivery_date\": \"2025-12-01\"}', 'PO-TEST-123', 'corr-12345', 1),
(6, 1, 'SUPPLY CHAIN - CREATE PURCHASE_ORDER', NULL, 'supply_chain', 'create_purchase_order', NULL, NULL, 'test-user', 'Test User', NULL, NULL, 'medium', 'pending', 1, '2025-10-25 16:33:28', '2025-10-25 16:33:28', '{\"items\": [{\"quantity\": 100, \"unit_price\": 5000, \"description\": \"Test Material\", \"raw_material_id\": 1, \"unit_of_measure\": \"KG\"}], \"notes\": \"Test PO for approval workflow\", \"branch_id\": 1, \"created_by\": \"test-user\", \"supplier_id\": 1, \"expected_delivery_date\": \"2025-12-01\"}', 'PO-TEST-123', 'corr-12345', 1),
(7, 1, 'SUPPLY CHAIN - CREATE PURCHASE_ORDER', NULL, 'supply_chain', 'create_purchase_order', NULL, NULL, 'test-user', 'Test User', NULL, NULL, 'medium', 'pending', 1, '2025-10-25 16:33:38', '2025-10-25 16:33:38', '{\"items\": [{\"quantity\": 100, \"unit_price\": 5000, \"description\": \"Test Material\", \"raw_material_id\": 1, \"unit_of_measure\": \"KG\"}], \"notes\": \"Test PO for approval workflow - end to end\", \"branch_id\": 1, \"created_by\": \"test-user\", \"supplier_id\": 1, \"expected_delivery_date\": \"2025-12-01\"}', 'SUPPLY_CHAIN-CREATE_PURCHASE_ORDER-1761410018371-9d9yh', 'corr-1761410018371', 1),
(8, 1, 'SUPPLY CHAIN - CREATE PURCHASE_ORDER', NULL, 'supply_chain', 'create_purchase_order', NULL, NULL, '8', 'Admin User', NULL, NULL, 'medium', 'pending', 1, '2025-10-25 16:42:18', '2025-10-25 16:42:18', '{\"items\": [{\"unit_price\": \"0.00\", \"description\": \"SORGHUM WASTE\", \"raw_material_id\": 254, \"unit_of_measure\": \"KG\"}], \"notes\": \"\", \"branch_id\": 1, \"supplier_id\": 4636, \"expected_delivery_date\": \"2025-11-01\"}', 'SUPPLY_CHAIN-CREATE_PURCHASE_ORDER-1761410538634-89qt8', 'corr-1761410538634', 1),
(9, 1, 'SUPPLY CHAIN - CREATE PURCHASE_ORDER', NULL, 'supply_chain', 'create_purchase_order', NULL, NULL, '8', 'Admin User', NULL, NULL, 'medium', 'pending', 1, '2025-10-25 16:43:21', '2025-10-25 16:43:21', '{\"items\": [{\"unit_price\": \"0.00\", \"description\": \"SORGHUM WASTE\", \"raw_material_id\": 254, \"unit_of_measure\": \"KG\"}], \"notes\": \"\", \"branch_id\": 1, \"supplier_id\": 4633, \"expected_delivery_date\": \"2025-10-31\"}', 'SUPPLY_CHAIN-CREATE_PURCHASE_ORDER-1761410601133-97nhf', 'corr-1761410601133', 1);

-- --------------------------------------------------------

--
-- Table structure for table `approval_step_progress`
--

CREATE TABLE `approval_step_progress` (
  `id` int NOT NULL,
  `request_id` int NOT NULL,
  `step_id` int NOT NULL,
  `status` enum('pending','in_progress','completed','failed') DEFAULT 'pending',
  `started_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `due_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `approval_step_progress`
--

INSERT INTO `approval_step_progress` (`id`, `request_id`, `step_id`, `status`, `started_at`, `completed_at`, `due_at`, `created_at`) VALUES
(1, 5, 1, 'in_progress', NULL, NULL, '2025-10-26 16:32:39', '2025-10-25 16:32:38'),
(2, 6, 1, 'in_progress', NULL, NULL, '2025-10-26 16:33:29', '2025-10-25 16:33:28'),
(3, 7, 1, 'in_progress', NULL, NULL, '2025-10-26 16:33:38', '2025-10-25 16:33:38'),
(4, 8, 1, 'in_progress', NULL, NULL, '2025-10-26 16:42:19', '2025-10-25 16:42:18'),
(5, 9, 1, 'in_progress', NULL, NULL, '2025-10-26 16:43:21', '2025-10-25 16:43:21');

-- --------------------------------------------------------

--
-- Table structure for table `approval_workflows`
--

CREATE TABLE `approval_workflows` (
  `id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `module` varchar(100) NOT NULL,
  `operation` varchar(100) NOT NULL,
  `description` text,
  `auto_approve` tinyint(1) DEFAULT '0',
  `sequential_approval` tinyint(1) DEFAULT '0',
  `status` enum('active','inactive','draft') DEFAULT 'active',
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(1) DEFAULT '1' COMMENT 'Whether workflow is active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `approval_workflows`
--

INSERT INTO `approval_workflows` (`id`, `name`, `module`, `operation`, `description`, `auto_approve`, `sequential_approval`, `status`, `created_by`, `created_at`, `updated_at`, `active`) VALUES
(1, 'Purchase Order Approval', 'supply_chain', 'create', 'Approval workflow for purchase orders', 0, 1, 'active', 1, '2025-08-07 21:39:56', '2025-08-21 08:34:12', 1),
(2, 'Supplier Management', 'supply_chain', 'update', 'Approval workflow for supplier updates', 1, 0, 'active', 1, '2025-08-07 21:39:56', '2025-08-21 08:34:12', 1),
(3, 'Quality Control Report', 'supply_chain', 'create', 'Approval workflow for quality control reports', 0, 1, 'active', 1, '2025-08-07 21:39:56', '2025-08-21 08:34:12', 1),
(4, 'Financial Transaction', 'finance', 'create', 'Approval workflow for financial transactions', 0, 1, 'active', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56', 1),
(5, 'Purchase Order Creation', 'supply_chain', 'create_purchase_order', 'Approval workflow for creating new purchase orders - requires approval for amounts over $10,000', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(6, 'Purchase Order Updates', 'supply_chain', 'update_purchase_order', 'Approval workflow for updating existing purchase orders - requires approval for significant changes', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(7, 'Purchase Order Deletion', 'supply_chain', 'delete_purchase_order', 'Approval workflow for deleting purchase orders - requires approval for audit trail', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(8, 'Supplier Creation', 'supply_chain', 'create_supplier', 'Approval workflow for creating new suppliers - requires approval for vendor management', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(9, 'Supplier Updates', 'supply_chain', 'update_supplier', 'Approval workflow for updating supplier information - requires approval for data integrity', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(10, 'Supplier Deletion', 'supply_chain', 'delete_supplier', 'Approval workflow for deleting suppliers - requires approval for audit trail', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(11, 'Raw Material Deletion', 'supply_chain', 'delete_raw_material', 'Approval workflow for deleting raw materials - requires approval for inventory control', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(12, 'Vehicle Deletion', 'supply_chain', 'delete_vehicle', 'Approval workflow for deleting vehicles - requires approval for fleet management', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(13, 'Weighbridge Record Updates', 'supply_chain', 'update_weighbridge_record', 'Approval workflow for updating weighbridge records - requires approval for data integrity', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(14, 'Quality Inspection Updates', 'supply_chain', 'update_quality_inspection', 'Approval workflow for updating quality inspections - requires approval for data integrity', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(15, 'Payment Processing', 'supply_chain', 'create_payment', 'Approval workflow for processing payments - requires approval for financial control', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(16, 'Cost Updates', 'supply_chain', 'update_purchase_order_costs', 'Approval workflow for updating purchase order costs - requires approval for budget control', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(17, 'Purchase Order Stage Progression', 'supply_chain', 'update_purchase_order_stage', 'Approval workflow for advancing purchase order stages - requires approval for process control', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(18, 'End of Day Completion', 'supply_chain', 'complete_end_of_day', 'Approval workflow for completing end of day processes - requires approval for data integrity', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(19, 'Report Export', 'supply_chain', 'export_reports', 'Approval workflow for exporting sensitive reports - requires approval for data security', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(20, 'Gate Clearance Management', 'supply_chain', 'manage_gate_clearance', 'Approval workflow for gate clearance operations - requires approval for security control', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1),
(21, 'Vehicle Registration Management', 'supply_chain', 'manage_vehicle_registration', 'Approval workflow for vehicle registration operations - requires approval for fleet control', 0, 1, 'active', 1, '2025-08-21 08:18:33', '2025-08-21 08:34:12', 1);

-- --------------------------------------------------------

--
-- Table structure for table `audit_logs`
--

CREATE TABLE `audit_logs` (
  `log_id` int NOT NULL,
  `event_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Type of event (CREATE, UPDATE, DELETE, READ, LOGIN, etc.)',
  `module_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Module where the event occurred',
  `entity_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Entity type (user, role, permission, etc.)',
  `entity_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ID of the affected entity',
  `performed_by` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User who performed the action',
  `user_role` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Role of the user who performed the action',
  `action_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'When the action occurred',
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Location information',
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'IP address of the user',
  `device_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Device and browser information',
  `old_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin COMMENT 'Previous data (for updates)',
  `new_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin COMMENT 'New data (for creates/updates)',
  `additional_info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin COMMENT 'Additional context information',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `conversations`
--

CREATE TABLE `conversations` (
  `id` int NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Title for group chats, or null for direct messages where title is derived from participant names',
  `type` enum('direct','group') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'direct' COMMENT 'Type of conversation: direct (1-on-1) or group',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `conversations`
--

INSERT INTO `conversations` (`id`, `title`, `type`, `created_at`, `updated_at`) VALUES
(61, 'Abdullahi hr', 'direct', '2025-10-30 22:34:34', '2025-10-30 22:35:31'),
(62, 'Abdullahi supp', 'direct', '2025-10-30 22:39:34', '2025-10-30 22:39:45');

-- --------------------------------------------------------

--
-- Table structure for table `conversation_participants`
--

CREATE TABLE `conversation_participants` (
  `conversation_id` int NOT NULL,
  `user_id` int NOT NULL,
  `last_read_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp when the user last read messages in this conversation',
  `joined_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `conversation_participants`
--

INSERT INTO `conversation_participants` (`conversation_id`, `user_id`, `last_read_at`, `joined_at`) VALUES
(61, 6, '2025-10-30 22:46:04', '2025-10-30 22:34:34'),
(61, 7, '2025-10-30 22:39:56', '2025-10-30 22:34:34'),
(62, 7, '2025-10-30 22:39:34', '2025-10-30 22:39:34'),
(62, 8, '2025-10-30 22:39:34', '2025-10-30 22:39:34');

-- --------------------------------------------------------

--
-- Table structure for table `crud_operations_registry`
--

CREATE TABLE `crud_operations_registry` (
  `id` int NOT NULL,
  `module` varchar(100) NOT NULL,
  `operation` varchar(100) NOT NULL,
  `entity_type` varchar(100) NOT NULL,
  `requires_approval` tinyint(1) DEFAULT '0',
  `approval_workflow_id` int DEFAULT NULL,
  `description` text,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `crud_operations_registry`
--

INSERT INTO `crud_operations_registry` (`id`, `module`, `operation`, `entity_type`, `requires_approval`, `approval_workflow_id`, `description`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'supply_chain', 'create', 'purchase_order', 1, 1, 'Creating new purchase orders requires approval', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(2, 'supply_chain', 'update', 'supplier', 1, 2, 'Updating supplier information requires approval', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(3, 'quality_control', 'create', 'quality_report', 1, 3, 'Creating quality control reports requires approval', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(4, 'finance', 'create', 'financial_transaction', 1, 4, 'Creating financial transactions requires approval', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(5, 'supply_chain', 'read', 'purchase_order', 0, NULL, 'Reading purchase orders does not require approval', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56'),
(6, 'supply_chain', 'delete', 'purchase_order', 1, 1, 'Deleting purchase orders requires approval', 1, '2025-08-07 21:39:56', '2025-08-07 21:39:56');

-- --------------------------------------------------------

--
-- Table structure for table `delegations`
--

CREATE TABLE `delegations` (
  `id` int NOT NULL,
  `from_user_id` varchar(100) NOT NULL,
  `to_user_id` varchar(100) NOT NULL,
  `valid_from` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `valid_to` timestamp NULL DEFAULT NULL,
  `module` varchar(100) DEFAULT NULL,
  `operation` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `escalations`
--

CREATE TABLE `escalations` (
  `id` int NOT NULL,
  `step_id` int NOT NULL,
  `rule_json` json NOT NULL,
  `active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `logs`
--

CREATE TABLE `logs` (
  `id` int NOT NULL,
  `event_type` enum('CREATE','UPDATE','DELETE') NOT NULL,
  `module_name` varchar(255) NOT NULL,
  `entity_name` varchar(255) NOT NULL,
  `entity_id` int DEFAULT NULL,
  `performed_by` varchar(255) DEFAULT 'anonymous',
  `user_role` varchar(255) DEFAULT 'unknown',
  `action_time` datetime DEFAULT CURRENT_TIMESTAMP,
  `location` varchar(255) DEFAULT 'unknown',
  `ip_address` varchar(45) DEFAULT NULL,
  `device_info` text,
  `old_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `new_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `additional_info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `logs`
--

INSERT INTO `logs` (`id`, `event_type`, `module_name`, `entity_name`, `entity_id`, `performed_by`, `user_role`, `action_time`, `location`, `ip_address`, `device_info`, `old_data`, `new_data`, `additional_info`) VALUES
(1, 'CREATE', 'Supply Chain', 'auth', NULL, 'anonymous', 'unknown', '2025-02-02 00:32:25', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"jane@example.com\", \"role_id\": 2, \"password\": \"securepass\", \"module_id\": 1}', '{}'),
(2, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:47:47', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(3, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:47:50', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(4, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:48:04', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(5, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:48:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(6, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:48:36', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(7, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:48:38', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(8, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:48:47', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(9, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:52:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(10, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:59:46', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(11, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:59:48', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(12, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 08:59:49', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(13, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 09:02:11', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(14, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-03 09:03:48', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(15, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 08:31:38', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(16, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 09:23:29', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@gmail.com\", \"password\": \"bluegate\"}', '{}'),
(17, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 09:23:59', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(18, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 09:24:57', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate\", \"password\": \"bluegate\"}', '{}'),
(19, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(20, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:16', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(21, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:17', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(22, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(23, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(24, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(25, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(26, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(27, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(28, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(29, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(30, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(31, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(32, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(33, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(34, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(35, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(36, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(37, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(38, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(39, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(40, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(41, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(42, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(43, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(44, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:14:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"$2a$10$4sg.ddSvbtviHASULQxQ.OvwqsSbhNmHyfLWa7R1qZMoVvJkRvfh2\"}', '{}'),
(45, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:15:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"amin\"}', '{}'),
(46, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:15:12', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"amin\"}', '{}'),
(47, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:26:33', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"isamusa1@example.com\", \"password\": \"umar11\"}', '{}'),
(48, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:26:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"isamusa1@example.com\", \"password\": \"umar11\"}', '{}'),
(49, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:27:32', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"Isa Musa \", \"password\": \"umar11\"}', '{}'),
(50, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:27:33', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"Isa Musa \", \"password\": \"umar11\"}', '{}'),
(51, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:28:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"isamusa1@example.com\", \"password\": \"umar11\"}', '{}'),
(52, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 10:28:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"isamusa1@example.com\", \"password\": \"umar11\"}', '{}'),
(53, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:09:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(54, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:10:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(55, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:10:15', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(56, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:10:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(57, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:13:11', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(58, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:14:33', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"\", \"password\": \"\"}', '{}'),
(59, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:29:29', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(60, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:29:35', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(61, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:29:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(62, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:32:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(63, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:33:26', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(64, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:37:23', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"aimaiabdu@gmail.com\", \"password\": \"bluegate\"}', '{}'),
(65, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:40:25', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(66, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:43:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(67, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:46:41', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@blugate.com\", \"password\": \"bluegate\"}', '{}'),
(68, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:47:06', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\\\"\", \"password\": \"bluegate\"}', '{}'),
(69, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:47:16', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\\\"\", \"password\": \"bluegate\"}', '{}'),
(70, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:47:30', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegae.com\", \"password\": \"bluegate\"}', '{}'),
(71, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:47:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(72, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:48:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"ma\", \"password\": \"bluegate\"}', '{}'),
(73, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:48:29', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"ma\", \"password\": \"bluegate\"}', '{}'),
(74, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:48:50', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(75, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 15:53:23', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(76, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 18:26:28', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiab\", \"password\": \"blugate\"}', '{}'),
(77, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 18:27:15', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(78, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 19:05:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"asdf\", \"password\": \"asdf\"}', '{}'),
(79, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 19:06:16', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(80, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 19:07:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu\", \"password\": \"bluegate\"}', '{}'),
(81, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 19:07:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(82, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 19:07:40', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegaet\"}', '{}'),
(83, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-07 19:07:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(84, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:37:47', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(85, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:45:50', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(86, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:50:43', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(87, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:52:44', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(88, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:54:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"engrmaiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(89, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:54:51', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(90, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:57:25', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(91, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:59:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@blugate.com\", \"password\": \"bluegate\"}', '{}'),
(92, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 02:59:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(93, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:00:07', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(94, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:02:17', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(95, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:02:24', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(96, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:02:25', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(97, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:02:26', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(98, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:07:15', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(99, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:07:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(100, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:07:36', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(101, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:07:38', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(102, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:09:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(103, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:09:38', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(104, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:10:24', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(105, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:11:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(106, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:25:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(107, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:40:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(108, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 03:45:50', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(109, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 04:27:25', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(110, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 04:44:31', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(111, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 06:36:45', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"asdf\", \"password\": \"asdf\"}', '{}'),
(112, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 06:39:32', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(113, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 06:44:45', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(114, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 16:16:29', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(115, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 16:26:08', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(116, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 16:45:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.1 Safari/605.1.15', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(117, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 17:11:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"maiabdu@bluegate.com\", \"password\": \"bluegate\"}', '{}'),
(118, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-08 17:11:15', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(119, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:39:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(120, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:42:32', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(121, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:44:36', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(122, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:44:49', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"asdf\"}', '{}'),
(123, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:44:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(124, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:45:01', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(125, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:45:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(126, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:49:12', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(127, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-09 06:50:48', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(128, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-14 16:26:01', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(129, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-15 14:01:57', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(130, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-22 09:53:47', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(131, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-22 10:33:16', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(132, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-22 10:40:34', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(133, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 14:16:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(134, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 14:18:34', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(135, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 14:28:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(136, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 16:52:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(137, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:21:09', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(138, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:24:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"username\": \"operations\", \"module_id\": 1}', '{}'),
(139, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:24:50', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(140, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:24:53', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(141, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:25:04', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(142, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:25:05', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(143, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:25:06', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(144, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:25:08', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(145, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:25:14', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 1}', '{}'),
(146, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:26:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(147, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:26:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(148, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:26:04', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(149, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:26:05', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(150, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:27:32', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(151, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:27:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(152, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:27:34', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(153, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:30', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(154, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:31', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(155, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:32', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(156, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(157, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(158, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(159, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}');
INSERT INTO `logs` (`id`, `event_type`, `module_name`, `entity_name`, `entity_id`, `performed_by`, `user_role`, `action_time`, `location`, `ip_address`, `device_info`, `old_data`, `new_data`, `additional_info`) VALUES
(160, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(161, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:33', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(162, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:28:45', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(163, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:32:23', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(164, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:33:39', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(165, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:33:40', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(166, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:33:42', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(167, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:34:36', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(168, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:34:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(169, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:34:38', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(170, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:35:20', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(171, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:35:26', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(172, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:52', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(173, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:54', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(174, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:54', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(175, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:54', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(176, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:54', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(177, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:55', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(178, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:55', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(179, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:55', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(180, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:37:55', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(181, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:38:29', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(182, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:38:42', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(183, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:38:58', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(184, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(185, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(186, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(187, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(188, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(189, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(190, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(191, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(192, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(193, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(194, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(195, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(196, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(197, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(198, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(199, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:03', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(200, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:04', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(201, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:05', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(202, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:05', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(203, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:06', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(204, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:39:08', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(205, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:40:13', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(206, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:42:07', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(207, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:42:29', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(208, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:42:36', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(209, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:09', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(210, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:34', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(211, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:35', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(212, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:36', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(213, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:36', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(214, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(215, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(216, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(217, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:39', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(218, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:43:51', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(219, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:44:11', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": \"3\", \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(220, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:44:12', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": \"3\", \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(221, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:49:47', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"maiabdu@bluegate.com\", \"store\": \"3\", \"role_id\": 1, \"password\": \"bluegate\", \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(222, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:50:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"accounts@bluegate.com\", \"store\": \"3\", \"role_id\": 1, \"password\": \"bluegate\", \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(223, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:51:32', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"accounts@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": \"3\", \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(224, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:52:59', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"accounts@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": \"3\", \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(225, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:53:10', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"accounts@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(226, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:53:15', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"account2s@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(227, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:56:45', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"account2s@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(228, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 21:56:50', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"account5s@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(229, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:00:30', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"account5s@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(230, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:02:51', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"accouns@bluegate.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 3, \"username\": \"accounts\", \"module_id\": 3}', '{}'),
(231, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:03:44', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"supply@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"supply\", \"module_id\": 1}', '{}'),
(232, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:04:05', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"operations@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"operations\", \"module_id\": 2}', '{}'),
(233, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:05:46', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"md@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"md\", \"module_id\": 3}', '{}'),
(234, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:06:05', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"accounts@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"accounts\", \"module_id\": 4}', '{}'),
(235, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:06:30', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"audit@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"audit\", \"module_id\": 5}', '{}'),
(236, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:06:57', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"hr@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"hr\", \"module_id\": 6}', '{}'),
(237, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:07:11', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"cr@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"cr\", \"module_id\": 7}', '{}'),
(238, 'UPDATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:12:25', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"id\": \"1\", \"name\": \"Comprehensive software solutions\", \"email\": \"supply@css.com\", \"role_id\": \"1\", \"store_id\": \"2\", \"username\": \"supply\", \"module_id\": \"1\"}', '{}'),
(239, 'DELETE', 'User Management', 'auth', 1, 'anonymous', 'unknown', '2025-02-23 22:14:49', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{}', '{}'),
(240, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:18:19', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(241, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:18:35', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(242, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:18:37', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(243, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:18:57', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(244, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:19:17', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(245, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:19:29', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(246, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:19:45', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(247, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:19:53', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(248, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:20:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(249, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:20:03', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(250, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:20:28', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(251, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:20:30', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(252, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:20:31', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(253, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:23:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(254, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:23:23', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(255, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:23:30', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(256, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:23:42', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(257, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:24:57', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(258, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:25:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations\", \"password\": \"bluegate\"}', '{}'),
(259, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:25:15', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(260, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:26:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(261, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:26:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.ng\", \"password\": \"bluegate\"}', '{}'),
(262, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:26:33', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(263, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:26:54', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(264, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:27:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"hr@css.com\", \"password\": \"bluegate\"}', '{}'),
(265, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:27:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"cr@css.com\", \"password\": \"bluegate\"}', '{}'),
(266, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:27:32', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(267, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:36:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(268, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 22:38:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(269, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:37:32', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(270, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:37:42', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(271, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:48:30', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(272, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:48:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operation@css.com\", \"password\": \"bluegate\"}', '{}'),
(273, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:48:41', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(274, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:48:50', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(275, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:49:00', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(276, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:49:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(277, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:49:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(278, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:50:25', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(279, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:51:42', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit\", \"password\": \"bluegate\"}', '{}'),
(280, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:51:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(281, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-23 23:54:57', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(282, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 00:05:58', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts.com\", \"password\": \"bluegate\"}', '{}'),
(283, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 00:06:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(284, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 00:13:29', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(285, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:22:47', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(286, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:23:45', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(287, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:27:27', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(288, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:27:48', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(289, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:28:08', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(290, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:29:42', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"bluegate\"}', '{}'),
(291, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:29:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(292, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 02:34:07', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(293, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:24:36', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(294, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:33:00', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(295, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:35:09', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(296, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:35:11', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(297, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:35:13', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(298, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:45:07', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"supp@css.com\", \"role_id\": 1, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"cr\", \"module_id\": 1, \"phone_number\": \"08109315440\"}', '{}'),
(299, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:45:32', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(300, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:47:29', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(301, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:53:51', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(302, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 03:56:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(303, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 04:02:30', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(304, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 04:12:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(305, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 04:12:04', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(306, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 04:13:45', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"permissionIds\": [3, 4, 5]}', '{}'),
(307, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:40:48', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(308, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:41:25', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(309, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:42:16', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audits@css.com\", \"password\": \"bluegate\"}', '{}'),
(310, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:42:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(311, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:42:41', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(312, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:42:51', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(313, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 11:43:07', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(314, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:00:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(315, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 12:10:43', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [3, 4, 5]}', '{}');
INSERT INTO `logs` (`id`, `event_type`, `module_name`, `entity_name`, `entity_id`, `performed_by`, `user_role`, `action_time`, `location`, `ip_address`, `device_info`, `old_data`, `new_data`, `additional_info`) VALUES
(316, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:11:51', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(317, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 12:12:26', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [3, 4, 5]}', '{}'),
(318, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 12:13:07', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [11]}', '{}'),
(319, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:13:21', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(320, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:13:23', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(321, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:13:27', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(322, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 12:15:10', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [11]}', '{}'),
(323, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 12:15:11', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [11]}', '{}'),
(324, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:15:18', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(325, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:15:42', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(326, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:19:52', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(327, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 12:20:01', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [11]}', '{}'),
(328, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:20:09', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(329, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 12:20:54', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(330, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 13:02:17', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(331, 'CREATE', 'User Management', 'role_permissions', NULL, 'anonymous', 'unknown', '2025-02-24 13:06:07', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"storeId\": \"1\", \"moduleId\": \"1\", \"permissionIds\": [11]}', '{}'),
(332, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 13:06:23', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"blugeate\"}', '{}'),
(333, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 13:06:30', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"blugate\"}', '{}'),
(334, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 13:06:34', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(335, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 13:26:30', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(336, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 13:26:41', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(337, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 14:30:55', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(338, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 15:00:29', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(339, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 15:14:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(340, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 15:15:53', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(341, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 15:21:40', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"name\": \"Abdullahi Ibrahim Maiabdu\", \"email\": \"gate@css.com\", \"role_id\": 6, \"password\": \"bluegate\", \"store_id\": 1, \"username\": \"gate\", \"module_id\": 1, \"phone_number\": \"08109315440\"}', '{}'),
(342, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-24 18:55:45', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(343, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-25 13:31:24', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(344, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-02-26 00:44:36', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply@css.com\", \"password\": \"bluegate\"}', '{}'),
(345, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 10:59:00', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(346, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 13:41:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp\", \"password\": \"bluegate\"}', '{}'),
(347, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 13:41:09', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(348, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 13:41:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(349, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 13:41:16', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp\", \"password\": \"bluegate\"}', '{}'),
(350, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 13:41:31', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp\", \"password\": \"bluegate\"}', '{}'),
(351, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-03-14 13:41:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36', 'null', '{\"email\": \"supply\", \"password\": \"bluegate\"}', '{}'),
(352, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-05-01 21:49:12', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(353, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-05-13 11:44:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(354, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-05-18 14:21:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(355, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-05-18 14:42:30', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(356, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-05-18 14:42:44', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(357, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 06:02:43', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(358, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 06:05:34', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(359, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 06:19:46', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(360, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 10:38:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@supp.com\", \"password\": \"bluegate\"}', '{}'),
(361, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 10:38:14', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"bluegate\"}', '{}'),
(362, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 10:38:26', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@supp.com\", \"password\": \"bluegate\"}', '{}'),
(363, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 20:53:40', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@supp.com\", \"password\": \"bluegate\"}', '{}'),
(364, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 20:54:02', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(365, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 20:54:51', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(366, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 20:57:24', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(367, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 20:58:15', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(368, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 21:00:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations\", \"password\": \"bluegate\"}', '{}'),
(369, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 21:00:39', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(370, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-09 21:00:50', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(371, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-10 07:47:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(372, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-10 19:29:56', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(373, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-10 21:19:56', 'unknown', '::ffff:127.0.0.1', 'curl/8.1.2', 'null', '{\"name\": \"Test User\", \"email\": \"test@example.com\", \"role_id\": 1, \"password\": \"password123\", \"store_id\": 1, \"username\": \"testuser\", \"module_id\": 1, \"phone_number\": \"1234567890\"}', '{}'),
(374, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-10 21:19:59', 'unknown', '::ffff:127.0.0.1', 'curl/8.1.2', 'null', '{\"email\": \"test@example.com\", \"password\": \"password123\"}', '{}'),
(375, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-10 21:21:41', 'unknown', '::ffff:127.0.0.1', 'curl/8.1.2', 'null', '{\"type\": \"direct\", \"title\": \"Test Conversation\", \"participants\": [14]}', '{}'),
(376, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-10 21:21:51', 'unknown', '::ffff:127.0.0.1', 'curl/8.1.2', 'null', '{\"email\": \"test@example.com\", \"password\": \"password123\"}', '{}'),
(377, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-10 23:36:08', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(378, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-12 05:01:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(379, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-12 05:40:40', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(380, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-12 06:28:47', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(381, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-12 06:29:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@supp.com\", \"password\": \"bluegate\"}', '{}'),
(382, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-12 06:29:10', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(383, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-12 06:31:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(384, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-13 15:35:01', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(385, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-13 15:48:23', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(386, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-13 18:35:55', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(387, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-15 04:59:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(388, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-15 05:23:37', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(389, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-15 07:26:24', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(390, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-15 07:27:20', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"type\": \"private\", \"title\": \"Chat with [object Object]\", \"participants\": [2, {\"id\": 1, \"name\": \"John Doe\", \"isOnline\": true, \"lastSeen\": null, \"username\": \"johndoe\"}]}', '{}'),
(391, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-15 07:27:31', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"type\": \"private\", \"title\": \"Chat with [object Object]\", \"participants\": [2, {\"id\": 1, \"name\": \"John Doe\", \"isOnline\": true, \"lastSeen\": null, \"username\": \"johndoe\"}]}', '{}'),
(392, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-15 07:27:33', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"type\": \"private\", \"title\": \"Chat with [object Object]\", \"participants\": [2, {\"id\": 5, \"name\": \"Charlie Wilson\", \"isOnline\": true, \"lastSeen\": null, \"username\": \"charliewilson\"}]}', '{}'),
(393, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 09:21:16', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(394, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-20 10:04:23', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"type\": \"private\", \"title\": \"Chat with [object Object]\", \"participants\": [8, {\"id\": 2, \"name\": \"Jane Smith\", \"isOnline\": true, \"lastSeen\": null, \"username\": \"janesmith\"}]}', '{}'),
(395, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 15:18:41', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(396, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 15:55:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(397, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 19:52:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(398, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 19:58:26', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"name\": \"Baba\", \"email\": \"baba@gmail.com\", \"role_id\": 5, \"password\": \"hybrid2025\", \"store_id\": 1, \"username\": \"\", \"module_id\": 1, \"phone_number\": \"08109315440\"}', '{}'),
(399, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-20 20:11:44', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"type\": \"private\", \"title\": \"Chat with [object Object]\", \"participants\": [8, {\"id\": 1, \"name\": \"John Doe\", \"isOnline\": true, \"lastSeen\": null, \"username\": \"johndoe\"}]}', '{}'),
(400, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 20:40:26', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.1 Safari/605.1.15', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(401, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:08:01', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"opertions@supp.com\", \"password\": \"bluegate\"}', '{}'),
(402, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:08:05', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"opertions@css.com\", \"password\": \"bluegate\"}', '{}'),
(403, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:08:24', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(404, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:16:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(405, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:18:37', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"bluegate\"}', '{}'),
(406, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:18:41', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"bluegate\"}', '{}'),
(407, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:18:44', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"md\"}', '{}'),
(408, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:18:48', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"md\"}', '{}'),
(409, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:18:52', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md\", \"password\": \"bluegate\"}', '{}'),
(410, 'UPDATE', 'User Management', 'users', 5, 'anonymous', 'unknown', '2025-08-20 21:21:08', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"newPassword\": \"bluegate\", \"oldPassword\": \"bluegate01\"}', '{}'),
(411, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:22:02', 'unknown', '::ffff:127.0.0.1', 'insomnia/10.3.0', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\", \"username\": \"\"}', '{}'),
(412, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:22:58', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css\", \"password\": \"bluegate\"}', '{}'),
(413, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-20 21:23:04', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(414, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 05:54:18', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(415, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 06:05:19', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(416, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 06:43:03', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(417, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 07:34:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(418, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 07:59:16', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(419, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 08:17:31', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(420, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 08:57:54', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(421, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 09:21:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"audit@css.com\", \"password\": \"bluegate\"}', '{}'),
(422, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 09:30:58', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(423, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 09:34:31', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(424, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 09:43:21', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(425, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 09:47:39', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(426, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 10:02:13', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(427, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 10:09:43', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"accounts@css.com\", \"password\": \"bluegate\"}', '{}'),
(428, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 11:54:08', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluefate\"}', '{}'),
(429, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 11:55:22', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(430, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 12:02:07', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(431, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 12:42:07', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(432, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 14:28:03', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(433, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 14:35:54', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(434, 'CREATE', 'User Management', 'chat', NULL, 'anonymous', 'unknown', '2025-08-21 14:45:00', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"type\": \"private\", \"title\": \"Chat with [object Object]\", \"participants\": [8, {\"id\": 2, \"name\": \"Jane Smith\", \"isOnline\": true, \"lastSeen\": null, \"username\": \"janesmith\"}]}', '{}'),
(435, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 14:49:57', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"name\": \"Ibrahim Hybrid\", \"email\": \"hybrid@gmail.com\", \"role_id\": 4, \"password\": \"hybrid2025\", \"store_id\": 1, \"username\": \"\", \"module_id\": 1, \"phone_number\": \"08109315440\"}', '{}'),
(436, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 15:18:58', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}'),
(437, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 15:20:35', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"supp@css.com\", \"password\": \"bluegate\"}', '{}'),
(438, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 16:17:03', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"operations@css.com\", \"password\": \"bluegate\"}', '{}'),
(439, 'CREATE', 'User Management', 'auth', NULL, 'anonymous', 'unknown', '2025-08-21 16:22:33', 'unknown', '::1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', 'null', '{\"email\": \"md@css.com\", \"password\": \"bluegate\"}', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` int NOT NULL,
  `conversation_id` int NOT NULL,
  `sender_id` int NOT NULL,
  `message_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `message_type` enum('text','image','file') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Original file name',
  `file_size` bigint DEFAULT NULL COMMENT 'File size in bytes',
  `file_url` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Public URL to access file',
  `file_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Server path to stored file',
  `file_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'MIME type of the file',
  `file_thumbnail_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Path to thumbnail for images'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `messages`
--

INSERT INTO `messages` (`id`, `conversation_id`, `sender_id`, `message_content`, `message_type`, `created_at`, `file_name`, `file_size`, `file_url`, `file_path`, `file_mime_type`, `file_thumbnail_path`) VALUES
(69, 61, 7, '', 'image', '2025-10-30 22:34:42', 'WhatsApp Image 2025-09-24 at 10.33.34 PM.jpeg', 97501, '/files/WhatsApp Image 2025-09-24 at 10.33.34 PM_1761863682516_283b6df7a6cfddcc.jpeg', '/home/dawendoski/Documents/Projects/hybrid-all/API-Hybrid-Auth/uploads/WhatsApp Image 2025-09-24 at 10.33.34 PM_1761863682516_283b6df7a6cfddcc.jpeg', 'image/jpeg', '/home/dawendoski/Documents/Projects/hybrid-all/API-Hybrid-Auth/uploads/thumbnails/WhatsApp Image 2025-09-24 at 10.33.34 PM_1761863682516_283b6df7a6cfddcc_thumb.jpg'),
(70, 61, 7, '', 'image', '2025-10-30 22:34:58', 'WhatsApp Image 2025-09-24 at 10.17.15 PM.jpeg', 158568, '/files/WhatsApp Image 2025-09-24 at 10.17.15 PM_1761863698825_8dd2ccdbc1777066.jpeg', '/home/dawendoski/Documents/Projects/hybrid-all/API-Hybrid-Auth/uploads/WhatsApp Image 2025-09-24 at 10.17.15 PM_1761863698825_8dd2ccdbc1777066.jpeg', 'image/jpeg', '/home/dawendoski/Documents/Projects/hybrid-all/API-Hybrid-Auth/uploads/thumbnails/WhatsApp Image 2025-09-24 at 10.17.15 PM_1761863698825_8dd2ccdbc1777066_thumb.jpg'),
(71, 61, 7, 'oga ', 'text', '2025-10-30 22:35:31', NULL, NULL, NULL, NULL, NULL, NULL),
(72, 62, 7, 'yo', 'text', '2025-10-30 22:39:45', NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `modules`
--

CREATE TABLE `modules` (
  `id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `modules`
--

INSERT INTO `modules` (`id`, `name`, `description`) VALUES
(1, 'Supply Chain', 'Handles supply chain and logistics'),
(2, 'Operations', 'Manages procurement and supplier relationships'),
(3, 'MD', 'Handles inventory and stock management'),
(4, 'Accounts', 'Manages financial transactions and reporting'),
(5, 'Audits', 'Auditing'),
(6, 'HR', 'Human resource'),
(7, 'CR', 'Custoner Relations'),
(8, 'CRM', 'Customer Relationship Management'),
(0, 'accounts', 'Accounting and Finance Module'),
(0, 'supply_chain', 'Supply Chain Management'),
(0, 'dms', 'Document Management System'),
(0, 'hr', 'Human Resources'),
(0, 'auth', 'Authentication System');

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `title` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `link` varchar(512) DEFAULT NULL,
  `type` varchar(50) DEFAULT 'info',
  `priority` varchar(50) DEFAULT 'normal',
  `icon` varchar(100) DEFAULT NULL,
  `source_module` varchar(100) DEFAULT NULL,
  `payload` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `read_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pending_operations`
--

CREATE TABLE `pending_operations` (
  `id` int NOT NULL,
  `approval_request_id` int NOT NULL,
  `operation_type` varchar(50) NOT NULL,
  `operation_details` json DEFAULT NULL,
  `status` enum('pending','approved','rejected','executed') DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` int NOT NULL,
  `module_id` int NOT NULL,
  `store_id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `module_id`, `store_id`, `name`, `description`) VALUES
(1, 1, 1, 'VIEW_INVENTORY', 'Can view inventory records'),
(2, 1, 1, 'MANAGE_STOCK', 'Can manage stock levels and updates'),
(3, 1, 1, 'CREATE_PURCHASE_ORDERS', 'Can create purchase orders'),
(4, 1, 1, 'APPROVE_PURCHASE_ORDERS', 'Can approve purchase orders'),
(5, 1, 1, 'VIEW_SUPPLIERS', 'Can view supplier information'),
(6, 1, 1, 'GENERATE_REPORTS', 'Can generate supply chain reports'),
(7, 1, 1, 'INSPECT_QUALITY', 'Conduct quality inspections on goods'),
(8, 1, 1, 'MANAGE_SHIPMENTS', 'Approve and track shipments'),
(9, 1, 0, 'VIEW_FINANCIALS', 'View financial reports related to supply chain'),
(10, 1, 0, 'MANAGE_COMPLIANCE', 'Ensure audit logs & regulatory compliance'),
(11, 1, 0, 'MANAGE_USERS', 'Assign roles & permissions to staff'),
(12, 1, 1, 'SUPPLY_CHAIN_RAW_MATERIALS_CREATE', 'Create raw material'),
(13, 1, 1, 'SUPPLY_CHAIN_RAW_MATERIALS_READ', 'View raw materials'),
(14, 1, 1, 'SUPPLY_CHAIN_RAW_MATERIALS_UPDATE', 'Update raw material'),
(15, 1, 1, 'SUPPLY_CHAIN_RAW_MATERIALS_UPDATE_PRICE', 'Update raw material price'),
(16, 1, 1, 'SUPPLY_CHAIN_RAW_MATERIALS_DELETE', 'Delete raw material'),
(17, 1, 1, 'SUPPLY_CHAIN_SUPPLIERS_CREATE', 'Create supplier'),
(18, 1, 1, 'SUPPLY_CHAIN_SUPPLIERS_READ', 'View suppliers'),
(19, 1, 1, 'SUPPLY_CHAIN_SUPPLIERS_UPDATE', 'Update supplier'),
(20, 1, 1, 'SUPPLY_CHAIN_SUPPLIER_BANKS_CREATE', 'Create supplier bank account'),
(21, 1, 1, 'SUPPLY_CHAIN_SUPPLIER_BANKS_READ', 'View supplier bank accounts'),
(22, 1, 1, 'SUPPLY_CHAIN_SUPPLIER_BANKS_SET_PRIMARY', 'Set primary supplier bank account'),
(23, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_CREATE', 'Create purchase order'),
(24, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_READ', 'List purchase orders'),
(25, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_READ_ONE', 'View purchase order details'),
(26, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_UPDATE', 'Update purchase order'),
(27, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_UPDATE_COSTS', 'Update purchase order costs'),
(28, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_UPDATE_OFFLOADING_COST', 'Update purchase order offloading cost'),
(29, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_UPDATE_GNC_ANALYSIS_COST', 'Update purchase order GNC analysis cost'),
(30, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_UPDATE_STAGE', 'Update purchase order stage'),
(31, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_DELETE', 'Delete purchase order'),
(32, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_VIEW_PRINT_DATA', 'View purchase order print data'),
(33, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_RECORD_PAYMENT', 'Record purchase order payment'),
(34, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDERS_VIEW_PAYMENTS', 'View purchase order payments'),
(35, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDER_ITEMS_ADD', 'Add items to purchase order'),
(36, 1, 1, 'SUPPLY_CHAIN_PURCHASE_ORDER_VEHICLES_ADD', 'Add vehicle to purchase order'),
(37, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_VIEW_MY_RECORDS', 'View own weighbridge records'),
(38, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_VIEW_RECORDS', 'View weighbridge records'),
(39, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_VIEW_PO_ITEMS', 'View PO items for weighbridge'),
(40, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_CREATE_RECORD', 'Create weighbridge record'),
(41, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_VIEW_RECORDS_BY_PO', 'View weighbridge records for PO'),
(42, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_VIEW_AVAILABLE_VEHICLES', 'View vehicles available for weighbridge'),
(43, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_UPDATE_RECORD', 'Update weighbridge record'),
(44, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_COMPLETE_PROCESS', 'Complete weighbridge process'),
(45, 1, 1, 'SUPPLY_CHAIN_WEIGHBRIDGE_DELETE_RECORD', 'Delete weighbridge record'),
(46, 1, 1, 'SUPPLY_CHAIN_GATE_SEARCH_PURCHASE_ORDERS', 'Search purchase orders at gate'),
(47, 1, 1, 'SUPPLY_CHAIN_GATE_REGISTER_ARRIVAL', 'Register arrival at gate'),
(48, 1, 1, 'SUPPLY_CHAIN_GATE_VIEW_VEHICLE_INFORMATION', 'View vehicle information for PO'),
(49, 1, 1, 'SUPPLY_CHAIN_GATE_VIEW_PURCHASE_ORDER_ITEMS', 'View PO items at gate'),
(50, 1, 1, 'SUPPLY_CHAIN_GATE_UPDATE_PURCHASE_ORDER_STAGE', 'Update PO stage at gate'),
(51, 1, 1, 'SUPPLY_CHAIN_GATE_VIEW_PURCHASE_ORDERS_BY_STAGE', 'View POs by stage at gate'),
(52, 1, 1, 'SUPPLY_CHAIN_QUALITY_VIEW_POS_BY_STAGE', 'View POs by stage for quality'),
(53, 1, 1, 'SUPPLY_CHAIN_QUALITY_CREATE_INSPECTION', 'Create quality inspection'),
(54, 1, 1, 'SUPPLY_CHAIN_QUALITY_VIEW_INSPECTIONS', 'View quality inspections for PO'),
(55, 1, 1, 'SUPPLY_CHAIN_QUALITY_LIST_INSPECTIONS', 'List quality inspections'),
(56, 1, 1, 'SUPPLY_CHAIN_QUALITY_UPDATE_INSPECTION', 'Update quality inspection'),
(57, 1, 1, 'SUPPLY_CHAIN_QUALITY_COMPLETE_PURCHASE_ORDER', 'Complete PO in quality'),
(58, 1, 1, 'SUPPLY_CHAIN_GATE_CLEARANCE_CREATE_OR_UPDATE', 'Create or update gate clearance'),
(59, 1, 1, 'SUPPLY_CHAIN_GATE_CLEARANCE_VIEW_BY_ORDER', 'View gate clearance by order'),
(60, 1, 1, 'SUPPLY_CHAIN_GATE_CLEARANCE_LIST', 'List all gate clearances'),
(61, 1, 1, 'SUPPLY_CHAIN_GATE_CLEARANCE_DELETE', 'Delete gate clearance by order'),
(62, 1, 1, 'SUPPLY_CHAIN_VEHICLE_REGISTRATION_CREATE', 'Register vehicle for delivery'),
(63, 1, 1, 'SUPPLY_CHAIN_VEHICLE_REGISTRATION_LIST_BY_ORDER', 'List vehicle registrations by order'),
(64, 1, 1, 'SUPPLY_CHAIN_VEHICLE_REGISTRATION_LIST', 'List vehicle registrations'),
(65, 1, 1, 'SUPPLY_CHAIN_VEHICLE_REGISTRATION_UPDATE_STATUS', 'Update vehicle registration status'),
(66, 1, 1, 'SUPPLY_CHAIN_VEHICLE_REGISTRATION_DELETE', 'Delete vehicle registration'),
(67, 1, 1, 'SUPPLY_CHAIN_ACCOUNTS_VIEW_QC_COMPLETED_POS', 'View QC completed purchase orders'),
(68, 1, 1, 'SUPPLY_CHAIN_ACCOUNTS_VIEW_PAYMENT_TRACKING', 'View payment tracking'),
(69, 1, 1, 'SUPPLY_CHAIN_ACCOUNTS_CREATE_PAYMENT_REQUEST', 'Create payment request'),
(70, 1, 1, 'SUPPLY_CHAIN_ACCOUNTS_UPDATE_PAYMENT_STATUS', 'Update payment status'),
(71, 1, 1, 'SUPPLY_CHAIN_ACCOUNTS_APPROVE_PAYMENT', 'Approve payment'),
(72, 1, 1, 'SUPPLY_CHAIN_REPORTS_DASHBOARD_VIEW_STATS', 'View dashboard stats report'),
(73, 1, 1, 'SUPPLY_CHAIN_REPORTS_PURCHASE_ORDERS_VIEW', 'View purchase order reports'),
(74, 1, 1, 'SUPPLY_CHAIN_REPORTS_PO_TRENDS_VIEW', 'View purchase order trends'),
(75, 1, 1, 'SUPPLY_CHAIN_REPORTS_PO_STATUS_SUMMARY_VIEW', 'View purchase order status summary'),
(76, 1, 1, 'SUPPLY_CHAIN_REPORTS_INVENTORY_VIEW', 'View inventory reports'),
(77, 1, 1, 'SUPPLY_CHAIN_REPORTS_LOW_STOCK_ALERTS_VIEW', 'View low stock alerts'),
(78, 1, 1, 'SUPPLY_CHAIN_REPORTS_STOCK_TURNOVER_VIEW', 'View stock turnover'),
(79, 1, 1, 'SUPPLY_CHAIN_REPORTS_STOCK_MOVEMENTS_VIEW', 'View stock movements'),
(80, 1, 1, 'SUPPLY_CHAIN_REPORTS_STOCK_ADJUSTMENTS_VIEW', 'View stock adjustments'),
(81, 1, 1, 'SUPPLY_CHAIN_REPORTS_STOCK_ADJUSTMENTS_CREATE', 'Create stock adjustment'),
(82, 1, 1, 'SUPPLY_CHAIN_REPORTS_SUPPLIER_PERFORMANCE_VIEW', 'View supplier performance reports'),
(83, 1, 1, 'SUPPLY_CHAIN_REPORTS_QUALITY_VIEW', 'View quality reports'),
(84, 1, 1, 'SUPPLY_CHAIN_REPORTS_QUALITY_TRENDS_VIEW', 'View quality trends'),
(85, 1, 1, 'SUPPLY_CHAIN_REPORTS_DEFECT_ANALYSIS_VIEW', 'View defect analysis'),
(86, 1, 1, 'SUPPLY_CHAIN_REPORTS_FINANCIAL_VIEW', 'View financial reports'),
(87, 1, 1, 'SUPPLY_CHAIN_REPORTS_COST_ANALYSIS_VIEW', 'View cost analysis'),
(88, 1, 1, 'SUPPLY_CHAIN_REPORTS_PAYMENT_STATUS_VIEW', 'View payment status reports'),
(89, 1, 1, 'SUPPLY_CHAIN_REPORTS_BUDGET_VARIANCE_VIEW', 'View budget variance reports'),
(90, 1, 1, 'SUPPLY_CHAIN_REPORTS_SUPPLIER_RISK_ASSESSMENT_VIEW', 'View supplier risk assessment reports'),
(91, 1, 1, 'SUPPLY_CHAIN_REPORTS_WEIGHBRIDGE_VIEW', 'View weighbridge reports'),
(92, 1, 1, 'SUPPLY_CHAIN_REPORTS_VEHICLE_UTILIZATION_VIEW', 'View vehicle utilization reports'),
(93, 1, 1, 'SUPPLY_CHAIN_REPORTS_EXPORT', 'Export reports'),
(94, 1, 1, 'SUPPLY_CHAIN_DASHBOARD_VIEW_STATS', 'View dashboard statistics'),
(95, 1, 1, 'SUPPLY_CHAIN_DASHBOARD_VIEW_DAILY_TRUCKS', 'View daily trucks count'),
(96, 1, 1, 'SUPPLY_CHAIN_DASHBOARD_VIEW_QUALITY_METRICS', 'View quality metrics'),
(97, 1, 1, 'SUPPLY_CHAIN_DASHBOARD_VIEW_SUPPLIER_PERFORMANCE', 'View supplier performance metrics'),
(98, 1, 1, 'SUPPLY_CHAIN_DASHBOARD_VIEW_FINANCIAL_METRICS', 'View financial metrics'),
(99, 1, 1, 'SUPPLY_CHAIN_DASHBOARD_VIEW_WEIGHBRIDGE_ACTIVITY', 'View weighbridge activity'),
(100, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_HEALTH', 'View EOD health'),
(101, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_DAILY_SUMMARY', 'View daily summary'),
(102, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_TASKS', 'View EOD tasks and alerts'),
(103, 1, 1, 'SUPPLY_CHAIN_EOD_MARK_TASK_COMPLETE', 'Mark EOD task complete'),
(104, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_LEDGER', 'View EOD ledger data'),
(105, 1, 1, 'SUPPLY_CHAIN_EOD_COMPLETE', 'Complete end of day process'),
(106, 1, 1, 'SUPPLY_CHAIN_EOD_LOCK', 'Lock end of day data'),
(107, 1, 1, 'SUPPLY_CHAIN_EOD_BACKUP_RECONCILE', 'Create EOD backup and reconcile'),
(108, 1, 1, 'SUPPLY_CHAIN_EOD_EXPORT', 'Export EOD report'),
(109, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_STATUS', 'View EOD status'),
(110, 1, 1, 'SUPPLY_CHAIN_EOD_UNLOCK', 'Unlock EOD data'),
(111, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_HISTORY', 'View EOD history'),
(112, 1, 1, 'SUPPLY_CHAIN_EOD_VALIDATE', 'Validate EOD data'),
(113, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_STATS', 'View EOD statistics'),
(114, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_PENDING_ITEMS', 'View pending EOD items'),
(115, 1, 1, 'SUPPLY_CHAIN_EOD_ADD_NOTE', 'Add note to EOD'),
(116, 1, 1, 'SUPPLY_CHAIN_EOD_VIEW_NOTES', 'View EOD notes'),
(117, 1, 1, 'SUPPLY_CHAIN_SSE_SUBSCRIBE_EVENTS', 'Subscribe to server-sent events'),
(0, 0, 0, 'create_users', 'Can create new users'),
(0, 0, 0, 'edit_users', 'Can edit user information'),
(0, 0, 0, 'delete_users', 'Can delete users'),
(0, 0, 0, 'view_reports', 'Can view reports'),
(0, 0, 0, 'manage_inventory', 'Can manage inventory'),
(0, 0, 0, 'approve_documents', 'Can approve documents');

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` int NOT NULL,
  `module_id` int NOT NULL,
  `store_id` int DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `description` text,
  `parent_role_id` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `module_id`, `store_id`, `name`, `description`, `parent_role_id`) VALUES
(1, 1, 1, 'Head of Supply Chain', 'Manages overall supply chain operations', NULL),
(2, 1, 1, 'Inventory Manager', 'Oversees inventory levels and stock movements', 1),
(3, 1, 0, 'Warehouse Staff', 'Handles physical stock in the warehouse', 2),
(4, 1, 0, 'Procurement Officer', 'Responsible for procurement and supplier management', 1),
(5, 1, 0, 'Finance Officer', 'Manages financial transactions related to procurement', 1),
(6, 1, 0, 'Quality Control Officer', 'Inspects goods and manages quality control', 1),
(7, 1, 0, 'Logistics Manager', 'Handles shipments & deliveries', 1),
(8, 1, 0, 'Compliance Officer', 'Ensures regulatory & audit compliance', 5),
(19, 1, 0, 'Gate Security Pass', 'Handles Gate Security on Supply Chain', NULL),
(20, 8, 0, 'CRM Manager', 'Customer Relationship Management Manager', NULL),
(0, 0, 0, 'super_admin', 'Super Administrator with full access', NULL),
(0, 0, 0, 'admin', 'Administrator', NULL),
(0, 0, 0, 'manager', 'Manager', NULL),
(0, 0, 0, 'user', 'Regular User', NULL),
(0, 0, 0, 'viewer', 'Read-only User', NULL);

--
-- Triggers `roles`
--
DELIMITER $$
CREATE TRIGGER `inherit_permissions` AFTER INSERT ON `roles` FOR EACH ROW BEGIN
    IF NEW.parent_role_id IS NOT NULL THEN
        INSERT INTO role_permissions (role_id, permission_id)
        SELECT NEW.id, permission_id FROM role_permissions WHERE role_id = NEW.parent_role_id
        ON DUPLICATE KEY UPDATE role_id = role_id, permission_id = permission_id;
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `role_modules`
--

CREATE TABLE `role_modules` (
  `id` int NOT NULL,
  `role_id` int NOT NULL,
  `module_id` int NOT NULL,
  `store_id` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `role_permissions`
--

CREATE TABLE `role_permissions` (
  `id` int NOT NULL,
  `role_id` int NOT NULL,
  `permission_id` int NOT NULL,
  `store_id` int NOT NULL,
  `module_id` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `role_permissions`
--

INSERT INTO `role_permissions` (`id`, `role_id`, `permission_id`, `store_id`, `module_id`) VALUES
(2, 1, 11, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `stores`
--

CREATE TABLE `stores` (
  `id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `location` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `stores`
--

INSERT INTO `stores` (`id`, `name`, `location`, `created_at`) VALUES
(1, 'Kaduna HQTRS', 'Kaduna', '2025-02-03 09:00:53'),
(2, 'Ibadan', 'Ibadan', '2025-02-03 09:00:53'),
(3, 'Asaba', 'Delta', '2025-02-26 09:16:13'),
(4, 'Kano', 'Kano', '2025-02-26 09:16:13'),
(0, 'Main Store', 'Headquarters', '2025-11-04 08:09:38'),
(0, 'Branch Store', 'Downtown Branch', '2025-11-04 08:09:38');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `phone_number` varchar(20) DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `module_id` int DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `is_blocked` tinyint(1) DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `username`, `password`, `phone_number`, `role_id`, `module_id`, `store_id`, `is_blocked`, `is_active`, `last_login`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'supp@css.com', 'supp', '$2a$10$07MvvW6d9EZITUx5SCLRiO.Dr9VyMm9GJ.q.hRYrd7U5MkzOvcPZ6', NULL, 1, 5, 1, 0, 1, NULL, '2025-11-04 08:09:38', '2025-11-04 08:09:38'),
(2, 'Accounts Admin', 'accounts@css.com', 'accounts', '$2a$10$07MvvW6d9EZITUx5SCLRiO.Dr9VyMm9GJ.q.hRYrd7U5MkzOvcPZ6', NULL, 2, 1, 1, 0, 1, NULL, '2025-11-04 08:09:38', '2025-11-04 08:09:38'),
(3, 'Regular User', 'user@css.com', 'user', '$2a$10$07MvvW6d9EZITUx5SCLRiO.Dr9VyMm9GJ.q.hRYrd7U5MkzOvcPZ6', NULL, 4, 1, 1, 0, 1, NULL, '2025-11-04 08:09:38', '2025-11-04 08:09:38');

-- --------------------------------------------------------

--
-- Table structure for table `user_permissions`
--

CREATE TABLE `user_permissions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `permission_id` int NOT NULL,
  `store_id` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `user_permissions`
--

INSERT INTO `user_permissions` (`id`, `user_id`, `permission_id`, `store_id`) VALUES
(1, 2, 5, 0),
(6, 2, 5, 0),
(7, 2, 6, 0),
(8, 2, 7, 0);

-- --------------------------------------------------------

--
-- Table structure for table `webhook_deliveries`
--

CREATE TABLE `webhook_deliveries` (
  `id` int NOT NULL,
  `request_id` int NOT NULL,
  `url` varchar(500) NOT NULL,
  `method` enum('POST','PUT','PATCH') DEFAULT 'POST',
  `payload` json DEFAULT NULL,
  `response_status` int DEFAULT NULL,
  `response_body` text,
  `success` tinyint(1) DEFAULT '0',
  `attempt_count` int DEFAULT '1',
  `next_retry_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `workflows`
--

CREATE TABLE `workflows` (
  `id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `module` varchar(100) NOT NULL,
  `operation` varchar(100) NOT NULL,
  `description` text,
  `active` tinyint(1) DEFAULT '1',
  `created_by` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `workflows`
--

INSERT INTO `workflows` (`id`, `name`, `module`, `operation`, `description`, `active`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'Purchase Order Approval', 'supply_chain', 'create_purchase_order', 'Standard approval workflow for purchase orders', 1, 'system', '2025-10-25 15:45:00', '2025-10-25 15:45:00'),
(2, 'Purchase Order Approval', 'supply_chain', 'create_purchase_order', 'Standard approval workflow for purchase orders', 1, 'system', '2025-10-25 15:51:54', '2025-10-25 15:51:54'),
(3, 'Purchase Order Approval', 'supply_chain', 'create_purchase_order', 'Standard approval workflow for purchase orders', 1, 'system', '2025-10-25 15:54:47', '2025-10-25 15:54:47');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `conversations`
--
ALTER TABLE `conversations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `conversation_participants`
--
ALTER TABLE `conversation_participants`
  ADD PRIMARY KEY (`conversation_id`,`user_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `messages`
--
ALTER TABLE `messages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `conversation_id` (`conversation_id`),
  ADD KEY `sender_id` (`sender_id`),
  ADD KEY `idx_messages_file_type` (`message_type`),
  ADD KEY `idx_messages_file_name` (`file_name`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD UNIQUE KEY `username` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `conversations`
--
ALTER TABLE `conversations`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=63;

--
-- AUTO_INCREMENT for table `messages`
--
ALTER TABLE `messages`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=73;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
